﻿using System;
namespace ACustomException
{
    // własna klasa wyjątku
    public class MyCustomException : System.Exception
    {
        public MyCustomException(string message)
            : base(message) // przekaż komunikat klasie bazowej
        {

        }
    }

    class Tester
    {
        public void Run()
        {
            try
            {
                Console.WriteLine("Tu otwórz plik");
                double a = 0;
                double b = 5;
                Console.WriteLine("{0} / {1} = {2}", a, b, DoDivide(a, b));
                Console.WriteLine("Ta linijka może zostać wydrukowana albo i nie");
            }
            // najpierw najbardziej charakterystyczny wyjątek
            catch (System.DivideByZeroException e)
            {
                Console.WriteLine("\nDivideByZeroException! Msg: {0}", e.Message);
                Console.WriteLine("\nHelpLink: {0}\n", e.HelpLink);
            }
            // przechwyć własny wyjątek
            catch (MyCustomException e)
            {
                Console.WriteLine("\nMyCustomException! Msg: {0}", e.Message);
                Console.WriteLine("\nHelpLink: {0}\n", e.HelpLink);
            }
            catch // przechwyć jakikolwiek nieprzechwycony wyjątek
            {
                Console.WriteLine("Przechwycono nieznany wyjątek");
            }
            finally
            {
                Console.WriteLine("Tu zamknij plik");
            }
        }
        // wykonaj dzielenie, jeśli jest dopuszczalne
        public double DoDivide(double a, double b)
        {
            if (b == 0)
            {
                DivideByZeroException e = new DivideByZeroException();
                e.HelpLink = "http://www.libertyassociates.com";
                throw e;
            }
            if (a == 0)
            {
                // utwórz instancję własnego wyjątku
                MyCustomException e = new MyCustomException(
                   "Dzielnik nie może być zerem");
                e.HelpLink = "http://www.libertyassociates.com/NoZeroDivisor.htm";
                throw e;
            }
            return a / b;
        }

        static void Main()
        {
            Console.WriteLine("Wejście w Main()...");
            Tester t = new Tester();
            t.Run();
            Console.WriteLine("Wyjście z Main()...");
        }
    }
}